<?php
/**
 * This file is used to generate the "Tickers" page in the admin.
 *
 * @package live-news
 */

if ( ! current_user_can( get_option( $this->shared->get( 'slug' ) . '_tickers_menu_capability' ) ) ) {
	wp_die( esc_html__( 'You do not have sufficient permissions to access this page.', 'daln' ) );
}

?>

<!-- process data -->

<?php

// Initialize variables -----------------------------------------------------------------------------------------------.
$dismissible_notice_a = array();

// Preliminary operations ---------------------------------------------------------------------------------------------.
global $wpdb;

// Sanitization -------------------------------------------------------------------------------------------------------.
$data['edit_id']             = isset( $_GET['edit_id'] ) ? intval( $_GET['edit_id'], 10 ) : null;
$data['delete_id']           = isset( $_POST['delete_id'] ) ? intval( $_POST['delete_id'], 10 ) : null;
$data['update_id']           = isset( $_POST['update_id'] ) ? intval( $_POST['update_id'], 10 ) : null;
$data['form_submitted']      = isset( $_POST['form_submitted'] ) ? intval( $_POST['form_submitted'], 10 ) : null;
$data['delete_transient_id'] = isset( $_POST['delete_transient_id'] ) ? intval( $_POST['delete_transient_id'], 10 ) : null;

// Filter and search data.
$data['s'] = isset( $_GET['s'] ) ? sanitize_text_field( $_GET['s'] ) : null;

if ( ! is_null( $data['update_id'] ) || ! is_null( $data['form_submitted'] ) ) {

	// Nonce verification.
	check_admin_referer( 'daln_create_update_ticker', 'daln_create_update_ticker_nonce' );

	// Sanitization ---------------------------------------------------------------------------------------------------.
	$name          = isset( $_POST['name'] ) ? sanitize_text_field( $_POST['name'] ) : null;
	$target        = isset( $_POST['target'] ) ? intval( $_POST['target'], 10 ) : null;
	$url           = isset( $_POST['url'] ) ? sanitize_textarea_field( $_POST['url'] ) : null;
	$enable_ticker = isset( $_POST['enable_ticker'] ) ? intval( $_POST['enable_ticker'], 10 ) : null;

	$source                            = isset( $_POST['source'] ) ? intval( $_POST['source'], 10 ) : null;
	$category                          = isset( $_POST['category'] ) ? intval( $_POST['category'], 10 ) : null;
	$url_rss                           = isset( $_POST['url_rss'] ) ? esc_url_raw( $_POST['url_rss'] ) : null;
	$twitter_username                  = isset( $_POST['twitter_username'] ) ? sanitize_text_field( $_POST['twitter_username'] ) : null;
	$twitter_oauth_access_token        = isset( $_POST['twitter_oauth_access_token'] ) ? sanitize_text_field( $_POST['twitter_oauth_access_token'] ) : null;
	$twitter_oauth_access_token_secret = isset( $_POST['twitter_oauth_access_token_secret'] ) ? sanitize_text_field( $_POST['twitter_oauth_access_token_secret'] ) : null;
	$twitter_consumer_key              = isset( $_POST['twitter_consumer_key'] ) ? sanitize_text_field( $_POST['twitter_consumer_key'] ) : null;
	$twitter_consumer_secret           = isset( $_POST['twitter_consumer_secret'] ) ? sanitize_text_field( $_POST['twitter_consumer_secret'] ) : null;
	$twitter_strip_links               = isset( $_POST['twitter_strip_links'] ) ? intval( $_POST['twitter_strip_links'], 10 ) : null;
	$twitter_strip_hashtags            = isset( $_POST['twitter_strip_hashtags'] ) ? intval( $_POST['twitter_strip_hashtags'], 10 ) : null;
	$twitter_strip_usernames           = isset( $_POST['twitter_strip_usernames'] ) ? intval( $_POST['twitter_strip_usernames'], 10 ) : null;
	$clock_source                      = isset( $_POST['clock_source'] ) ? intval( $_POST['clock_source'], 10 ) : null;
	$clock_offset                      = isset( $_POST['clock_offset'] ) ? intval( $_POST['clock_offset'], 10 ) : null;
	$clock_format                      = isset( $_POST['clock_format'] ) ? sanitize_text_field( $_POST['clock_format'] ) : null;

	$enable_rtl_layout          = isset( $_POST['enable_rtl_layout'] ) ? intval( $_POST['enable_rtl_layout'], 10 ) : null;
	$enable_with_mobile_devices = isset( $_POST['enable_with_mobile_devices'] ) ? intval( $_POST['enable_with_mobile_devices'], 10 ) : null;
	$hide_featured_news         = isset( $_POST['hide_featured_news'] ) ? intval( $_POST['hide_featured_news'], 10 ) : null;
	$open_news_as_default       = isset( $_POST['open_news_as_default'] ) ? intval( $_POST['open_news_as_default'], 10 ) : null;
	$enable_links               = isset( $_POST['enable_links'] ) ? intval( $_POST['enable_links'], 10 ) : null;
	$open_links_new_tab         = isset( $_POST['open_links_new_tab'] ) ? intval( $_POST['open_links_new_tab'], 10 ) : null;
	$hide_clock                 = isset( $_POST['hide_clock'] ) ? intval( $_POST['hide_clock'], 10 ) : null;
	$clock_autoupdate           = isset( $_POST['clock_autoupdate'] ) ? intval( $_POST['clock_autoupdate'], 10 ) : null;
	$clock_autoupdate_time      = isset( $_POST['clock_autoupdate_time'] ) ? intval( $_POST['clock_autoupdate_time'], 10 ) : null;
	$number_of_sliding_news     = isset( $_POST['number_of_sliding_news'] ) ? intval( $_POST['number_of_sliding_news'], 10 ) : null;
	$sliding_speed              = isset( $_POST['sliding_speed'] ) ? intval( $_POST['sliding_speed'], 10 ) : null;
	$sliding_delay              = isset( $_POST['sliding_delay'] ) ? intval( $_POST['sliding_delay'], 10 ) : null;

	$cached_cycles        = isset( $_POST['cached_cycles'] ) ? intval( $_POST['cached_cycles'], 10 ) : null;
	$transient_expiration = isset( $_POST['transient_expiration'] ) ? intval( $_POST['transient_expiration'], 10 ) : null;

	$featured_title_maximum_length          = isset( $_POST['featured_title_maximum_length'] ) ? intval( $_POST['featured_title_maximum_length'], 10 ) : null;
	$featured_excerpt_maximum_length        = isset( $_POST['featured_excerpt_maximum_length'] ) ? intval( $_POST['featured_excerpt_maximum_length'], 10 ) : null;
	$sliding_news_maximum_length            = isset( $_POST['sliding_news_maximum_length'] ) ? intval( $_POST['sliding_news_maximum_length'], 10 ) : null;
	$featured_title_font_size               = isset( $_POST['featured_title_font_size'] ) ? intval( $_POST['featured_title_font_size'], 10 ) : null;
	$featured_excerpt_font_size             = isset( $_POST['featured_excerpt_font_size'] ) ? intval( $_POST['featured_excerpt_font_size'], 10 ) : null;
	$sliding_news_font_size                 = isset( $_POST['sliding_news_font_size'] ) ? intval( $_POST['sliding_news_font_size'], 10 ) : null;
	$clock_font_size                        = isset( $_POST['clock_font_size'] ) ? intval( $_POST['clock_font_size'], 10 ) : null;
	$sliding_news_margin                    = isset( $_POST['sliding_news_margin'] ) ? intval( $_POST['sliding_news_margin'], 10 ) : null;
	$sliding_news_padding                   = isset( $_POST['sliding_news_padding'] ) ? intval( $_POST['sliding_news_padding'], 10 ) : null;
	$font_family                            = isset( $_POST['font_family'] ) ? sanitize_text_field( $_POST['font_family'] ) : null;
	$google_font                            = isset( $_POST['google_font'] ) ? sanitize_text_field( $_POST['google_font'] ) : null;
	$featured_news_title_color              = isset( $_POST['featured_news_title_color'] ) ? sanitize_text_field( $_POST['featured_news_title_color'] ) : null;
	$featured_news_title_color_hover        = isset( $_POST['featured_news_title_color_hover'] ) ? sanitize_text_field( $_POST['featured_news_title_color_hover'] ) : null;
	$featured_news_excerpt_color            = isset( $_POST['featured_news_excerpt_color'] ) ? sanitize_text_field( $_POST['featured_news_excerpt_color'] ) : null;
	$sliding_news_color                     = isset( $_POST['sliding_news_color'] ) ? sanitize_text_field( $_POST['sliding_news_color'] ) : null;
	$sliding_news_color_hover               = isset( $_POST['sliding_news_color_hover'] ) ? sanitize_text_field( $_POST['sliding_news_color_hover'] ) : null;
	$clock_text_color                       = isset( $_POST['clock_text_color'] ) ? sanitize_text_field( $_POST['clock_text_color'] ) : null;
	$featured_news_background_color         = isset( $_POST['featured_news_background_color'] ) ? sanitize_text_field( $_POST['featured_news_background_color'] ) : null;
	$featured_news_background_color_opacity = isset( $_POST['featured_news_background_color_opacity'] ) ? floatval( $_POST['featured_news_background_color_opacity'] ) : null;
	$sliding_news_background_color          = isset( $_POST['sliding_news_background_color'] ) ? sanitize_text_field( $_POST['sliding_news_background_color'] ) : null;
	$sliding_news_background_color_opacity  = isset( $_POST['sliding_news_background_color_opacity'] ) ? floatval( $_POST['sliding_news_background_color_opacity'] ) : null;
	$open_button_image                      = isset( $_POST['open_button_image'] ) ? esc_url_raw( $_POST['open_button_image'] ) : null;
	$close_button_image                     = isset( $_POST['close_button_image'] ) ? esc_url_raw( $_POST['close_button_image'] ) : null;
	$clock_background_image                 = isset( $_POST['clock_background_image'] ) ? esc_url_raw( $_POST['clock_background_image'] ) : null;

	$url_mode = isset( $_POST['url_mode'] ) ? intval( $_POST['url_mode'], 10 ) : null;

	// Validation -----------------------------------------------------------------------------------------------------.

	// validation on "Name".
	if ( mb_strlen( trim( $name ) ) === 0 || mb_strlen( $name ) > 100 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid value in the "Name" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// validation on "URL RSS".
	if ( ( 3 === intval( $source, 10 ) && 0 === mb_strlen( trim( $url_rss ) ) )
		|| ( 3 === intval( $source, 10 ) && ! preg_match( $this->shared->url_regex, trim( $url_rss ) ) )
		|| ( 3 === intval( $source, 10 ) && mb_strlen( $url_rss ) > 2083 ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid URL in the "Source RSS" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Twitter Username".
	if ( ( 4 === intval( $source, 10 ) && 0 === mb_strlen( trim( $twitter_username ) ) )
		|| ( mb_strlen( $twitter_username ) > 255 ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid value in the "Twitter Username" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Twitter Oauth Access Token".
	if ( ( 4 === intval( $source, 10 ) && 0 === mb_strlen( trim( $twitter_oauth_access_token ) ) )
		|| ( mb_strlen( $twitter_oauth_access_token ) > 255 ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid value in the "Twitter Oauth Access Token" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Twitter Oauth Access Token Secret".
	if ( ( 4 === intval( $source, 10 ) && 0 === mb_strlen( trim( $twitter_oauth_access_token_secret ) ) )
		|| ( mb_strlen( $twitter_oauth_access_token_secret ) > 255 ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid value in the "Twitter Oauth Access Token Secret" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Twitter Consumer Key".
	if ( ( 4 === intval( $source, 10 ) && 0 === mb_strlen( trim( $twitter_consumer_key ) ) )
		|| ( mb_strlen( $twitter_consumer_key ) > 255 ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid value in the "Twitter Consumer Key" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Twitter Consumer Secret".
	if ( ( 4 === intval( $source, 10 ) && 0 === mb_strlen( trim( $twitter_consumer_secret ) ) )
		|| ( mb_strlen( $twitter_consumer_secret ) > 255 ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid value in the "Twitter Consumer Secret" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Sliding Speed".
	if ( intval( $sliding_speed, 10 ) < 1 || intval( $sliding_speed, 10 ) > 10 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 1 and 10 in the "Sliding Speed" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Sliding Delay".
	if ( intval( $sliding_delay, 10 ) < 0 || intval( $sliding_delay, 10 ) > 1000000000 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 0 and 1000000000 in the "Sliding Delay" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Featured Title Maximum Length".
	if ( intval( $featured_title_maximum_length, 10 ) < 1 || intval( $featured_title_maximum_length, 10 ) > 1000 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 1 and 1000 in the "Featured Title Maximum Length" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Featured Excerpt Maximum Length".
	if ( intval( $featured_excerpt_maximum_length, 10 ) < 1 || intval( $featured_excerpt_maximum_length, 10 ) > 1000 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 1 and 1000 in the "Featured Excerpt Maximum Length" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Sliding News Maximum Length".
	if ( intval( $sliding_news_maximum_length, 10 ) < 1 || intval( $sliding_news_maximum_length, 10 ) > 1000 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 1 and 1000 in athe "Sliding News Maximum Length" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Featured News Title Font Size".
	if ( intval( $featured_title_font_size, 10 ) < 1 || intval( $featured_title_font_size, 10 ) > 38 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 1 and 38 in the "Featured News Title Font Size" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Featured News Excerpt Font Size".
	if ( intval( $featured_excerpt_font_size, 10 ) < 1 || intval( $featured_excerpt_font_size, 10 ) > 28 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 1 and 28 in the "Featured News Excerpt Font Size" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Sliding News Font Size".
	if ( intval( $sliding_news_font_size, 10 ) < 1 || intval( $sliding_news_font_size, 10 ) > 28 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 1 and 28 in the "Sliding News Font Size" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Clock Font Size".
	if ( intval( $clock_font_size, 10 ) < 1 || intval( $clock_font_size, 10 ) > 28 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 1 and 28 in the "Clock Font Size" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Sliding News Margin".
	if ( intval( $sliding_news_margin, 10 ) < 0 || intval( $sliding_news_margin, 10 ) > 999 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 0 and 999 in the "Sliding News Margin" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Sliding News Padding".
	if ( intval( $sliding_news_padding, 10 ) < 0 || intval( $sliding_news_padding, 10 ) > 999 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 0 and 999 in the "Sliding News Padding" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Cached Cycles".
	if ( intval( $cached_cycles, 10 ) < 0 || intval( $cached_cycles, 10 ) > 1000000000 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 0 and 1000000000 in the "Cached Cycles" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Transient Expiration".
	if ( intval( $transient_expiration, 10 ) < 0 || intval( $transient_expiration, 10 ) > 1000000000 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 0 and 1000000000 in the "Transient Expiration" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Featured News Background Color".
	if ( ! preg_match( $this->shared->hex_rgb_regex, $featured_news_background_color ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid color in the "Featured News Background Color" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Sliding News Background Color".
	if ( ! preg_match( $this->shared->hex_rgb_regex, $sliding_news_background_color ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid color in the "Sliding News Background Color" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Sliding News Background Color Opacity".
	if ( $sliding_news_background_color_opacity < 0 || $sliding_news_background_color_opacity > 1 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 0 and 1 in the "Sliding News Background Color Opacity" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Font Family".
	if ( ! preg_match( $this->shared->font_family_regex, stripslashes( $font_family ) ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid value in the "Font Family" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Gooogle Font".
	if ( mb_strlen( trim( $google_font ) ) > 0 && ! preg_match( $this->shared->url_regex, trim( $google_font ) ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid value in the "Google Font" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Open Button Image".
	if ( ! preg_match( $this->shared->url_regex, trim( $open_button_image ) ) || mb_strlen( $open_button_image ) > 2083 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid URL in the "Open Button Image" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Close Button Image".
	if ( ! preg_match( $this->shared->url_regex, trim( $close_button_image ) ) || mb_strlen( $close_button_image ) > 2083 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid URL in the "Close Button Image" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Clock Background Image".
	if ( ! preg_match( $this->shared->url_regex, trim( $clock_background_image ) ) || mb_strlen( $clock_background_image ) > 2083 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid URL in the "Clock Background Image" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Featured News Title Color".
	if ( ! preg_match( $this->shared->hex_rgb_regex, $featured_news_title_color ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid color in the "Featured News Title Color" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Featured News Title Color Hover".
	if ( ! preg_match( $this->shared->hex_rgb_regex, $featured_news_title_color_hover ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid color in the "Featured News Title Color Hover" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Featured News Excerpt Color".
	if ( ! preg_match( $this->shared->hex_rgb_regex, $featured_news_excerpt_color ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid color in the "Featured News Excerpt Color" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Sliding News Color".
	if ( ! preg_match( $this->shared->hex_rgb_regex, $sliding_news_color ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid color in the "Sliding News Color" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Sliding News Color Hover".
	if ( ! preg_match( $this->shared->hex_rgb_regex, $sliding_news_color_hover ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid color in the "Sliding News Color Hover" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Clock Text Color".
	if ( ! preg_match( $this->shared->hex_rgb_regex, $clock_text_color ) ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a valid color in the "Clock Text Color" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Validation on "Featured News Background Color Opacity".
	if ( $featured_news_background_color_opacity < 0 || $featured_news_background_color_opacity > 1 ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'Please enter a value included between 0 and 1 in the "Featured News Background Color Opacity" field.', 'daln' ),
			'class'   => 'error',
		);
		$invalid_data           = true;
	}

	// Do not save (and leave an error message) if a ticker with "Website" as a target already exists.
	if ( 1 === $target ) {
		$table_name = $wpdb->prefix . $this->shared->get( 'slug' ) . '_tickers';
		$row_obj    = $wpdb->get_row( "SELECT * from $table_name WHERE target = 1" );
		if ( null !== $row_obj ) {

			if ( is_null( $data['update_id'] ) || ( ! is_null( $data['update_id'] ) && intval( $row_obj->id, 10 ) !== $data['update_id'] ) ) {
				$dismissible_notice_a[] = array(
					'message' => __( 'A news ticker with "Website" as a target already exists.', 'daln' ),
					'class'   => 'error',
				);
				$invalid_data           = true;
			}
		}
	}
}

// Update ---------------------------------------------------------------.
if ( ! is_null( $data['update_id'] ) && ! isset( $invalid_data ) ) {

	// Update the database.
	$table_name = $wpdb->prefix . $this->shared->get( 'slug' ) . '_tickers';
	$safe_sql   = $wpdb->prepare(
		"UPDATE $table_name SET
                name = %s,
                target = %d,
                url = %s,
                source = %d,
                url_rss = %s,
                category = %d,
                twitter_username = %s,
                twitter_oauth_access_token = %s,
                twitter_oauth_access_token_secret = %s,
			    twitter_consumer_key = %s,
			    twitter_consumer_secret = %s,
			    twitter_strip_links = %d,
			    twitter_strip_hashtags = %d,
			    twitter_strip_usernames = %d,
                open_links_new_tab = %d,
                clock_offset = %d,
                clock_format = %s,
                clock_source = %d,
                clock_autoupdate = %d,
                clock_autoupdate_time = %d,
                sliding_speed = %d,
                sliding_delay = %d,
                number_of_sliding_news = %d,
                featured_title_maximum_length = %d,
                featured_excerpt_maximum_length = %d,
                sliding_news_maximum_length = %d,
                open_news_as_default = %d,
                hide_featured_news = %d,
                hide_clock = %d,
                enable_rtl_layout = %d,
                cached_cycles = %d,
                featured_news_background_color = %s,
                sliding_news_background_color = %s,
                sliding_news_background_color_opacity = %f,
                font_family = %s,
                google_font = %s,
                featured_title_font_size = %d,
				featured_excerpt_font_size = %d,
				sliding_news_font_size = %d,
				clock_font_size = %d,
				sliding_news_margin = %d,
				sliding_news_padding = %d,
                enable_with_mobile_devices = %d,
                open_button_image = %s,
                close_button_image = %s,
                clock_background_image = %s,
                featured_news_title_color = %s,
                featured_news_title_color_hover = %s,
                featured_news_excerpt_color = %s,
                sliding_news_color = %s,
                sliding_news_color_hover = %s,
                clock_text_color = %s,
                featured_news_background_color_opacity = %s,
                enable_ticker = %d,
                enable_links = %d,
                transient_expiration = %d,
                url_mode = %d
                WHERE id = %d",
		$name,
		$target,
		$url,
		$source,
		$url_rss,
		$category,
		$twitter_username,
		$twitter_oauth_access_token,
		$twitter_oauth_access_token_secret,
		$twitter_consumer_key,
		$twitter_consumer_secret,
		$twitter_strip_links,
		$twitter_strip_hashtags,
		$twitter_strip_usernames,
		$open_links_new_tab,
		$clock_offset,
		$clock_format,
		$clock_source,
		$clock_autoupdate,
		$clock_autoupdate_time,
		$sliding_speed,
		$sliding_delay,
		$number_of_sliding_news,
		$featured_title_maximum_length,
		$featured_excerpt_maximum_length,
		$sliding_news_maximum_length,
		$open_news_as_default,
		$hide_featured_news,
		$hide_clock,
		$enable_rtl_layout,
		$cached_cycles,
		$featured_news_background_color,
		$sliding_news_background_color,
		$sliding_news_background_color_opacity,
		$font_family,
		$google_font,
		$featured_title_font_size,
		$featured_excerpt_font_size,
		$sliding_news_font_size,
		$clock_font_size,
		$sliding_news_margin,
		$sliding_news_padding,
		$enable_with_mobile_devices,
		$open_button_image,
		$close_button_image,
		$clock_background_image,
		$featured_news_title_color,
		$featured_news_title_color_hover,
		$featured_news_excerpt_color,
		$sliding_news_color,
		$sliding_news_color_hover,
		$clock_text_color,
		$featured_news_background_color_opacity,
		$enable_ticker,
		$enable_links,
		$transient_expiration,
		$url_mode,
		$data['update_id']
	);

	$query_result = $wpdb->query( $safe_sql );

	if ( false !== $query_result ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'The news ticker has been successfully updated.', 'daln' ),
			'class'   => 'updated',
		);
	}
} else {

	// Add ------------------------------------------------------------------.
	if ( ! is_null( $data['form_submitted'] ) && ! isset( $invalid_data ) ) {

		// Insert into the database.
		$table_name = $wpdb->prefix . $this->shared->get( 'slug' ) . '_tickers';
		$safe_sql   = $wpdb->prepare(
			"INSERT INTO $table_name SET
                    name = %s,
                    target = %d,
                    url = %s,
                    source = %d,
                    url_rss = %s,
                    category = %d,
                    twitter_username = %s,
					twitter_oauth_access_token = %s,
					twitter_oauth_access_token_secret = %s,
					twitter_consumer_key = %s,
					twitter_consumer_secret = %s,
					twitter_strip_links = %d,
					twitter_strip_hashtags = %d,
					twitter_strip_usernames = %d,
                    open_links_new_tab = %d,
                    clock_offset = %d,
                    clock_format = %s,
                    clock_source = %d,
                    clock_autoupdate = %d,
                    clock_autoupdate_time = %d,
                    sliding_speed = %d,
                    sliding_delay = %d,
                    number_of_sliding_news = %d,
                    featured_title_maximum_length = %d,
                    featured_excerpt_maximum_length = %d,
                    sliding_news_maximum_length = %d,
                    open_news_as_default = %d,
                    hide_featured_news = %d,
                    hide_clock = %d,
                    enable_rtl_layout = %d,
                    cached_cycles = %d,
                    featured_news_background_color = %s,
                    sliding_news_background_color = %s,
                    sliding_news_background_color_opacity = %f,
                    font_family = %s,
                    google_font = %s,
					featured_title_font_size = %d,
					featured_excerpt_font_size = %d,
					sliding_news_font_size = %d,
					clock_font_size = %d,
					sliding_news_margin = %d,
					sliding_news_padding = %d,
                    enable_with_mobile_devices = %d,
                    open_button_image = %s,
                    close_button_image = %s,
                    clock_background_image = %s,
                    featured_news_title_color = %s,
                    featured_news_title_color_hover = %s,
                    featured_news_excerpt_color = %s,
                    sliding_news_color = %s,
                    sliding_news_color_hover = %s,
                    clock_text_color = %s,
                    featured_news_background_color_opacity = %s,
                    enable_ticker = %d,
                    enable_links = %d,
                    transient_expiration = %d,
                    url_mode = %d",
			$name,
			$target,
			$url,
			$source,
			$url_rss,
			$category,
			$twitter_username,
			$twitter_oauth_access_token,
			$twitter_oauth_access_token_secret,
			$twitter_consumer_key,
			$twitter_consumer_secret,
			$twitter_strip_links,
			$twitter_strip_hashtags,
			$twitter_strip_usernames,
			$open_links_new_tab,
			$clock_offset,
			$clock_format,
			$clock_source,
			$clock_autoupdate,
			$clock_autoupdate_time,
			$sliding_speed,
			$sliding_delay,
			$number_of_sliding_news,
			$featured_title_maximum_length,
			$featured_excerpt_maximum_length,
			$sliding_news_maximum_length,
			$open_news_as_default,
			$hide_featured_news,
			$hide_clock,
			$enable_rtl_layout,
			$cached_cycles,
			$featured_news_background_color,
			$sliding_news_background_color,
			$sliding_news_background_color_opacity,
			$font_family,
			$google_font,
			$featured_title_font_size,
			$featured_excerpt_font_size,
			$sliding_news_font_size,
			$clock_font_size,
			$sliding_news_margin,
			$sliding_news_padding,
			$enable_with_mobile_devices,
			$open_button_image,
			$close_button_image,
			$clock_background_image,
			$featured_news_title_color,
			$featured_news_title_color_hover,
			$featured_news_excerpt_color,
			$sliding_news_color,
			$sliding_news_color_hover,
			$clock_text_color,
			$featured_news_background_color_opacity,
			$enable_ticker,
			$enable_links,
			$transient_expiration,
			$url_mode
		);

		$query_result = $wpdb->query( $safe_sql );

		if ( false !== $query_result ) {
			$dismissible_notice_a[] = array(
				'message' => __( 'The news ticker has been successfully added.', 'daln' ),
				'class'   => 'updated',
			);
		}
	}
}

// Delete a transient .
if ( ! is_null( $data['delete_transient_id'] ) ) {

	// Nonce verification.
	check_admin_referer(
		'daln_delete_ticker_transient_' . $data['delete_transient_id'],
		'daln_delete_ticker_transient_nonce'
	);

	$deletion_result = delete_transient( 'daln_ticker_' . $data['delete_transient_id'] );

	if ( false !== $deletion_result ) {
		$dismissible_notice_a[] = array(
			'message' => __( 'The transient has been successfully deleted.', 'daln' ),
			'class'   => 'updated',
		);
	}
}

// Delete a ticker.
if ( ! is_null( $data['delete_id'] ) ) {

	// Nonce verification.
	check_admin_referer(
		'daln_delete_ticker_' . $data['delete_id'],
		'daln_delete_ticker_nonce'
	);

	// Delete the ticker only if it's not used by sliding news or featured news.
	if ( !$this->shared->ticker_is_used( $data['delete_id'] ) ) {

		// Delete the transient of the ticker.
		delete_transient( 'daln_ticker_' . $data['delete_id'] );

		// Delete this ticker.
		$table_name = $wpdb->prefix . $this->shared->get( 'slug' ) . '_tickers';
		$safe_sql   = $wpdb->prepare( "DELETE FROM $table_name WHERE id = %d ", $data['delete_id'] );

		$query_result = $wpdb->query( $safe_sql );

		if ( false !== $query_result ) {
			$dismissible_notice_a[] = array(
				'message' => __( 'The news ticker has been successfully deleted.', 'daln' ),
				'class'   => 'updated',
			);
		}
	}
}

// Get the ticker data.
$display_form = true;
if ( ! is_null( $data['edit_id'] ) ) {
	$table_name = $wpdb->prefix . $this->shared->get( 'slug' ) . '_tickers';
	$safe_sql   = $wpdb->prepare( "SELECT * FROM $table_name WHERE id = %d ", $data['edit_id'] );
	$ticker_obj = $wpdb->get_row( $safe_sql );
	if ( null === $ticker_obj ) {
		$display_form = false;
	}
}

?>

<!-- output -->

<div class="wrap">

	<?php if ( $this->shared->get_number_of_tickers() > 0 ) : ?>

		<div id="daext-header-wrapper">

			<h2><?php esc_html_e( 'Live News - News Tickers', 'daln' ); ?></h2>

			<!-- Search Form -->

			<form action="admin.php" method="get" id="daext-search-form">

				<input type="hidden" name="page" value="daln-tickers">

				<p><?php esc_html_e( 'Perform your Search', 'daln' ); ?></p>

				<?php
				if ( ! is_null( $data['s'] ) ) {
					if ( mb_strlen( trim( $data['s'] ) ) > 0 ) {
						$search_string = $data['s'];
					} else {
						$search_string = '';
					}
				} else {
					$search_string = '';
				}

				?>

				<input type="text" name="s"
						value="<?php echo esc_attr( stripslashes( $search_string ) ); ?>" autocomplete="off" maxlength="255">
				<input type="submit" value="">

			</form>

		</div>

	<?php else : ?>

		<div id="daext-header-wrapper" class="daext-clearfix">

			<h2><?php esc_html_e( 'Live News - News Tickers', 'daln' ); ?></h2>

		</div>

	<?php endif; ?>

	<div id="daext-menu-wrapper">

		<?php $this->dismissible_notice( $dismissible_notice_a ); ?>

		<!-- table -->

		<?php

		// Create the query part used to filter the results when a search is performed.
		if ( ! is_null( $data['s'] ) ) {
			if ( mb_strlen( trim( $data['s'] ) ) > 0 ) {
				$filter = $wpdb->prepare( 'WHERE (name LIKE %s)', '%' . $data['s'] . '%' );
			} else {
				$filter = '';
			}
		} else {
			$filter = '';
		}

		// Retrieve the total number of sliding news.
		$table_name  = $wpdb->prefix . $this->shared->get( 'slug' ) . '_tickers';
		$total_items = $wpdb->get_var( "SELECT COUNT(*) FROM $table_name $filter" );

		// Initialize the pagination class.
		require_once $this->shared->get( 'dir' ) . '/admin/inc/class-daln-pagination.php';
		$pag = new daln_pagination();
		$pag->set_total_items( $total_items );// Set the total number of items.
		$pag->set_record_per_page( 10 ); // Set records per page.
		$pag->set_target_page( 'admin.php?page=' . $this->shared->get( 'slug' ) . '-tickers' );// Set target page.
		$pag->set_current_page();// set the current page number.

		?>

		<!-- Query the database -->
		<?php
		$query_limit = $pag->query_limit();
		$results     = $wpdb->get_results( "SELECT * FROM $table_name $filter ORDER BY id DESC $query_limit ", ARRAY_A );
		?>

		<?php if ( count( $results ) > 0 ) : ?>

			<div class="daext-items-container">

				<!-- list of tables -->
				<table class="daext-items">
					<thead>
					<tr>
						<th>
							<div class="daext-items-th-inner">
								<div><?php esc_html_e( 'Name', 'daln' ); ?></div>
								<div class="help-icon" title="<?php esc_attr_e( 'The name of the news ticker.', 'daln' ); ?>"></div>
							</div>
						</th>
						<th>
							<div class="daext-items-th-inner">
								<div><?php esc_html_e( 'Target', 'daln' ); ?></div>
								<div class="help-icon" title="<?php esc_attr_e( 'The target of the news ticker.', 'daln' ); ?>"></div>
							</div>
						</th>
						<th>
							<div class="daext-items-th-inner">
								<div><?php esc_html_e( 'Source', 'daln' ); ?></div>
								<div class="help-icon" title="<?php esc_attr_e( 'The source of the news ticker.', 'daln' ); ?>"></div>
							</div>
						</th>
						<th></th>
					</tr>
					</thead>
					<tbody>

					<?php foreach ( $results as $result ) : ?>
						<tr>
							<td><?php echo esc_html( stripslashes( $result['name'] ) ); ?></td>
							<td><?php echo esc_html( stripslashes( $this->shared->get_textual_target( $result['target'] ) ) ); ?></td>
							<td><?php echo esc_html( stripslashes( $this->shared->get_textual_source( $result['source'] ) ) ); ?></td>
							<td class="icons-container">
								<div class="icons-container-inner">
									<?php if ( get_transient( 'daln_ticker_' . $result['id'] ) !== false ) : ?>
										<form method="POST" action="admin.php?page=<?php echo esc_attr( $this->shared->get( 'slug' ) ); ?>-tickers">
											<?php
											wp_nonce_field(
												'daln_delete_ticker_transient_' . $result['id'],
												'daln_delete_ticker_transient_nonce'
											);
											?>
											<input type="hidden" value="<?php echo esc_attr( $result['id'] ); ?>" name="delete_transient_id" >
											<input class="menu-icon update" type="submit" value="">
										</form>
									<?php else : ?>
										<div class="empty-icon-container"></div>
									<?php endif; ?>
									<a class="menu-icon edit" href="admin.php?page=<?php echo esc_attr( $this->shared->get( 'slug' ) ); ?>-tickers&edit_id=<?php echo esc_attr( $result['id'] ); ?>"></a>
									<?php if ( ! $this->shared->ticker_is_used( $result['id'] ) ) : ?>
										<form method="POST" action="admin.php?page=<?php echo esc_attr( $this->shared->get( 'slug' ) ); ?>-tickers">
											<?php wp_nonce_field( 'daln_delete_ticker_' . $result['id'], 'daln_delete_ticker_nonce' ); ?>
											<input type="hidden" value="<?php echo esc_attr( $result['id'] ); ?>" name="delete_id" >
											<input class="menu-icon delete" type="submit" value="">
										</form>
									<?php endif; ?>
								</div>
							</td>
						</tr>
					<?php endforeach; ?>

					</tbody>

				</table>

			</div>

			<!-- Display the pagination -->
			<?php if ( $pag->total_items > 0 ) : ?>
				<div class="daext-tablenav daext-clearfix">
					<div class="daext-tablenav-pages">
						<span class="daext-displaying-num"><?php echo esc_html( $pag->total_items ); ?> <?php esc_html_e( 'items', 'daln' ); ?></span>
						<?php $pag->show(); ?>
					</div>
				</div>
			<?php endif; ?>

		<?php endif; ?>

		<?php if ( $display_form ) : ?>

			<form method="POST" action="admin.php?page=<?php echo esc_attr( $this->shared->get( 'slug' ) ); ?>-tickers" autocomplete="off">

				<input type="hidden" value="1" name="form_submitted">
				<?php wp_nonce_field( 'daln_create_update_ticker', 'daln_create_update_ticker_nonce' ); ?>

				<?php if ( ! is_null( $data['edit_id'] ) ) : ?>

				<!-- Edit a Ticker -->

				<div class="daext-form-container">

					<h3 class="daext-form-title"><?php esc_html_e( 'Edit News Ticker', 'daln' ); ?> <?php echo esc_html( $ticker_obj->id ); ?></h3>

					<table class="daext-form">

						<input type="hidden" name="update_id" value="<?php echo esc_attr( $ticker_obj->id ); ?>" />

						<!-- Name -->
						<tr valign="top">
							<th scope="row"><label for="name"><?php esc_html_e( 'Name', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->name ) ); ?>" type="text" id="name" maxlength="100" size="30" name="name"/>
								<div class="help-icon" title="<?php esc_attr_e( 'The name of the news ticker.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Target -->
						<tr valign="top">
							<th scope="row"><label for="target"><?php esc_html_e( 'Target', 'daln' ); ?></label></th>
							<td>
								<select id="target" name="target" class="daext-display-none">
									<option value="1" <?php selected( $ticker_obj->target, 1 ); ?>><?php esc_html_e( 'Website', 'daln' ); ?></option>
									<option value="2" <?php selected( $ticker_obj->target, 2 ); ?>><?php esc_html_e( 'URL', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'This selection determines if the news ticker should be applied to the entire website or to a specific URL. Note that a news ticker associated with an URL has the priority over the news ticker associated with the entire website.', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- URL -->
						<tr valign="top">
							<th scope="row"><label for="url"><?php esc_html_e( 'Target URL', 'daln' ); ?></label></th>
							<td>
								<textarea type="text" id="url" maxlength="20830000" size="30" name="url"><?php echo esc_html( stripslashes( $ticker_obj->url ) ); ?></textarea>
								<div class="help-icon" title="<?php esc_attr_e( 'Enter one or more URLs. (one URL per line) This option is used only if the target of the news ticker is "URL".', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Enable Ticker -->
						<tr>
							<th scope="row"><?php esc_html_e( 'Enable Ticker', 'daln' ); ?></th>
							<td>
								<select id="enable-ticker" name="enable_ticker" class="daext-display-none">
									<option value="0" <?php selected( $ticker_obj->enable_ticker, 0 ); ?>><?php esc_html_e( 'No', 'daln' ); ?></option>
									<option value="1" <?php selected( $ticker_obj->enable_ticker, 1 ); ?>><?php esc_html_e( 'Yes', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'Use this option to enable or disable the news ticker on the front-end.', 'daln' ); ?>'></div>
							</td>
						</tr>

						<tr class="group-trigger" data-trigger-target="source-chart-configuration">
							<th scope="row" class="group-title"><?php esc_html_e( 'Source', 'daln' ); ?></th>
							<td>
								<div class="expand-icon"></div>
							</td>
						</tr>

						<!-- Source -->
						<tr class="source-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Source', 'daln' ); ?></th>
							<td>
								<select id="source" name="source">
									<option value="1" <?php selected( $ticker_obj->source, 1 ); ?>><?php esc_html_e( 'Manually Added', 'daln' ); ?></option>
									<option value="2" <?php selected( $ticker_obj->source, 2 ); ?>><?php esc_html_e( 'Posts', 'daln' ); ?></option>
									<option value="3" <?php selected( $ticker_obj->source, 3 ); ?>><?php esc_html_e( 'RSS', 'daln' ); ?></option>
									<option value="4" <?php selected( $ticker_obj->source, 4 ); ?>><?php esc_html_e( 'Twitter', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'This option determines where the news displayed in the news ticker are retrieved. Please note that with the "Twitter" source the news are displayed only in the sliding news area.', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Category -->
						<tr class="source-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Category', 'daln' ); ?></th>
							<td>
								<select id="category" name="category">
									<option value="0"><?php esc_html_e( 'All', 'daln' ); ?></option>

									<?php

									$args       = array(
										'type' => 'post',
									);
									$categories = get_categories( $args );
									foreach ( $categories as $category ) {
										echo '<option value="' . esc_attr( $category->term_id ) . '" ' . selected( $ticker_obj->category, $category->term_id ) . ' >' . esc_html( $category->name ) . '</option>';
									}

									?>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'Select if the news should be retrieved from all the posts or only from the posts of a specific category. This option is used only if the source of the news ticker is "Posts".', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- URL RSS -->
						<tr class="source-chart-configuration">
							<th scope="row"><label for="url-rss"><?php esc_html_e( 'Source RSS', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_url( stripslashes( $ticker_obj->url_rss ) ); ?>" type="text" id="url-rss" maxlength="2083" size="30" name="url_rss" />
								<div class="help-icon" title="<?php esc_attr_e( 'Enter the RSS Feed used to generate the news. This option is used only if the source of the news ticker is "RSS".', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Twitter Username -->
						<tr class="source-chart-configuration">
							<th scope="row"><label for="twitter-username"><?php esc_html_e( 'Twitter Username', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->twitter_username ) ); ?>" type="text" id="twitter-username" maxlength="255" size="30" name="twitter_username"/>
								<div class="help-icon" title="<?php esc_attr_e( 'Enter the Twitter username for which you want to retrieve the tweets. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Twitter Oauth Access Token -->
						<tr class="source-chart-configuration">
							<th scope="row"><label for="twitter-oauth-access-token"><?php esc_html_e( 'Twitter Oauth Access Token', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->twitter_oauth_access_token ) ); ?>" type="text" id="twitter-oauth-access-token" maxlength="255" size="30" name="twitter_oauth_access_token"/>
								<div class="help-icon" title="<?php esc_attr_e( 'Enter your Twitter Oauth Access Token. This token is available in the "Keys and Access Token" section of the Twitter App. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Twitter Oauth Access Token Secret -->
						<tr class="source-chart-configuration">
							<th scope="row"><label for="twitter-oauth-access-token-secret"><?php esc_html_e( 'Twitter Oauth Access Token Secret', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->twitter_oauth_access_token_secret ) ); ?>" type="text" id="twitter-oauth-access-token-secret" maxlength="255" size="30" name="twitter_oauth_access_token_secret"/>
								<div class="help-icon" title="<?php esc_attr_e( 'Enter your Twitter Oauth Access Token Secret. This token is available in the "Keys and Access Token" section of the Twitter App. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Twitter Consumer Key -->
						<tr class="source-chart-configuration">
							<th scope="row"><label for="twitter-consumer-key"><?php esc_html_e( 'Twitter Consumer Key', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->twitter_consumer_key ) ); ?>" type="text" id="twitter-consumer-key" maxlength="255" size="30" name="twitter_consumer_key"/>
								<div class="help-icon" title="<?php esc_attr_e( 'Enter your Twitter Consumer Key. This key is available in the "Keys and Access Token" section of the Twitter App. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Twitter Consumer Secret -->
						<tr class="source-chart-configuration">
							<th scope="row"><label for="twitter-consumer-secret"><?php esc_html_e( 'Twitter Consumer Secret', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->twitter_consumer_secret ) ); ?>" type="text" id="twitter-consumer-secret" maxlength="255" size="30" name="twitter_consumer_secret"/>
								<div class="help-icon" title="<?php esc_attr_e( 'Enter your Twitter Consumer Secret. This key is available in the "Keys and Access Token" section of the Twitter App. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Twitter Strip Links -->
						<tr class="source-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Twitter Strip Links', 'daln' ); ?></th>
							<td>
								<select id="twitter-strip-links" name="twitter_strip_links">
									<option value="0" <?php selected( $ticker_obj->twitter_strip_links, 0 ); ?>><?php esc_html_e( 'No', 'daln' ); ?></option>
									<option value="1" <?php selected( $ticker_obj->twitter_strip_links, 1 ); ?>><?php esc_html_e( 'Yes', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'This option determines if the links should be removed from the imported tweets. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Twitter Strip Hashtags -->
						<tr class="source-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Twitter Strip Hashtags', 'daln' ); ?></th>
							<td>
								<select id="twitter-strip-hashtags" name="twitter_strip_hashtags">
									<option value="0" <?php selected( $ticker_obj->twitter_strip_hashtags, 0 ); ?>><?php esc_html_e( 'No', 'daln' ); ?></option>
									<option value="1" <?php selected( $ticker_obj->twitter_strip_hashtags, 1 ); ?>><?php esc_html_e( 'Yes', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'This option determines if the hashtags should be removed from the imported tweets. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Twitter Strip Usernames -->
						<tr class="source-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Twitter Strip Usernames', 'daln' ); ?></th>
							<td>
								<select id="twitter-strip-usernames" name="twitter_strip_usernames">
									<option value="0" <?php selected( $ticker_obj->twitter_strip_usernames, 0 ); ?>><?php esc_html_e( 'No', 'daln' ); ?></option>
									<option value="1" <?php selected( $ticker_obj->twitter_strip_usernames, 1 ); ?>><?php esc_html_e( 'Yes', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'This option determines if the usernames should be removed from the imported tweets. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Clock Source -->
						<tr class="source-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Clock Source', 'daln' ); ?></th>
							<td>
								<select id="clock-source" name="clock_source">
									<option value="1" <?php selected( $ticker_obj->clock_source, 1 ); ?>><?php esc_html_e( 'Server Time', 'daln' ); ?></option>
									<option value="2" <?php selected( $ticker_obj->clock_source, 2 ); ?>><?php esc_html_e( 'User Time', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'Select if the time should be based on the server time or on the user time.', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Clock Offset -->
						<tr class="source-chart-configuration">
							<th scope="row"><label for="clock-offset"><?php esc_html_e( 'Clock Offset', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo intval( $ticker_obj->clock_offset, 10 ); ?>" type="text" id="clock-offset" maxlength="6" size="30" name="clock_offset" />
								<div class="help-icon" title="<?php esc_attr_e( 'The clock offset in seconds. Positive or negative values are allowed.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Clock Format -->
						<tr class="source-chart-configuration">
							<th scope="row"><label for="clock-format"><?php esc_html_e( 'Clock Format', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->clock_format ) ); ?>" type="text" id="clock-format" maxlength="40" size="30" name="clock_format" />
								<div class="help-icon" title="<?php esc_attr_e( 'Use this field to specify the clock format. The tokens supported by Moment.js should be used.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<tr class="group-trigger" data-trigger-target="behavior-chart-configuration">
							<th scope="row" class="group-title"><?php esc_attr_e( 'Behavior', 'daln' ); ?></th>
							<td>
								<div class="expand-icon"></div>
							</td>
						</tr>

						<!-- Enable RTL Layout -->
						<tr class="behavior-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Enable RTL Layout', 'daln' ); ?></th>
							<td>
								<select id="enable-rtl-layout" name="enable_rtl_layout">
									<option value="0" <?php selected( $ticker_obj->enable_rtl_layout, 0 ); ?>><?php esc_html_e( 'No', 'daln' ); ?></option>
									<option value="1" <?php selected( $ticker_obj->enable_rtl_layout, 1 ); ?>><?php esc_html_e( 'Yes', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'Select whether to enable or not the RTL layout.', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Enable with Mobile Devices -->
						<tr class="behavior-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Enable with Mobile Devices', 'daln' ); ?></th>
							<td>
								<select id="enable-with-mobile-devices" name="enable_with_mobile_devices">
									<option value="0" <?php selected( $ticker_obj->enable_with_mobile_devices, 0 ); ?>><?php esc_html_e( 'No', 'daln' ); ?></option>
									<option value="1" <?php selected( $ticker_obj->enable_with_mobile_devices, 1 ); ?>><?php esc_html_e( 'Yes', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'Select whether to display or not the news ticker with mobile devices. The user-agent string combined with specific HTTP headers are used to determine the device.', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Hide Featured News -->
						<tr class="behavior-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Hide Featured News', 'daln' ); ?></th>
							<td>
								<select id="hide-featured-news" name="hide_featured_news">
									<option value="1" <?php selected( $ticker_obj->hide_featured_news, 1 ); ?>><?php esc_html_e( 'No', 'daln' ); ?></option>
									<option value="2" <?php selected( $ticker_obj->hide_featured_news, 2 ); ?>><?php esc_html_e( 'Yes', 'daln' ); ?></option>
									<option value="3" <?php selected( $ticker_obj->hide_featured_news, 3 ); ?>><?php esc_html_e( 'Only with Mobile Devices', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'Select if the featured news area of the news ticker should be displayed.', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Open News as Default -->
						<tr class="behavior-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Open News as Default', 'daln' ); ?></th>
							<td>
								<select id="open-news-as-default" name="open_news_as_default">
									<option value="0" <?php selected( $ticker_obj->open_news_as_default, 0 ); ?>><?php esc_html_e( 'No', 'daln' ); ?></option>
									<option value="1" <?php selected( $ticker_obj->open_news_as_default, 1 ); ?>><?php esc_html_e( 'Yes', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'Select if the news ticker should be presented in the open status (with the featured news area visible) to the users. If the user opens or closes the news ticker the new status will be saved in a cookie and used to determine the default status of the news ticker for that specific user.', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Enable Links -->
						<tr class="behavior-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Enable Links', 'daln' ); ?></th>
							<td>
								<select id="enable-links" name="enable_links">
									<option value="0" <?php selected( $ticker_obj->enable_links, 0 ); ?>><?php esc_html_e( 'No', 'daln' ); ?></option>
									<option value="1" <?php selected( $ticker_obj->enable_links, 1 ); ?>><?php esc_html_e( 'Yes', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'Whether to apply or not the links associated with the news on the featured news title and on the sliding news.', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Open Links New Tab -->
						<tr class="behavior-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Open Links in New Tab', 'daln' ); ?></th>
							<td>
								<select id="open-links-new-tab" name="open_links_new_tab">
									<option value="0" <?php selected( $ticker_obj->open_links_new_tab, 0 ); ?>><?php esc_html_e( 'No', 'daln' ); ?></option>
									<option value="1" <?php selected( $ticker_obj->open_links_new_tab, 1 ); ?>><?php esc_html_e( 'Yes', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'Select if the links availble in the news ticker should be opened in a new tab.', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Hide Clock -->
						<tr class="behavior-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Hide Clock', 'daln' ); ?></th>
							<td>
								<select id="hide-clock" name="hide_clock">
									<option value="0" <?php selected( $ticker_obj->hide_clock, 0 ); ?>><?php esc_html_e( 'No', 'daln' ); ?></option>
									<option value="1" <?php selected( $ticker_obj->hide_clock, 1 ); ?>><?php esc_html_e( 'Yes', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'Select whether to display or not the clock.', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Clock Autoupdate -->
						<tr class="behavior-chart-configuration">
							<th scope="row"><?php esc_html_e( 'Clock Autoupdate', 'daln' ); ?></th>
							<td>
								<select id="clock-autoupdate" name="clock_autoupdate">
									<option value="0" <?php selected( $ticker_obj->clock_autoupdate, 0 ); ?>><?php esc_html_e( 'No', 'daln' ); ?></option>
									<option value="1" <?php selected( $ticker_obj->clock_autoupdate, 1 ); ?>><?php esc_html_e( 'Yes', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'Select whether to autoupdate or not the clock independently from the cycles of news received. This option is applied only if the source of the clock is "User Time".', 'daln' ); ?>'></div>
							</td>
						</tr>

						<!-- Clock Autoupdate Time -->
						<tr class="behavior-chart-configuration">
							<th scope="row"><label for="clock-autoupdate-time"><?php esc_html_e( 'Clock Autoupdate Time', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo intval( $ticker_obj->clock_autoupdate_time, 10 ); ?>" type="text" id="clock-autoupdate-time" maxlength="10" size="30" name="clock_autoupdate_time" />
								<div class="help-icon" title="<?php esc_attr_e( 'This option determines how frequent should be the clock autoupdate in seconds.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Number of Sliding News -->
						<tr class="behavior-chart-configuration">
							<th scope="row"><label for="number-of-sliding-news"><?php esc_html_e( 'Number of Sliding News', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->number_of_sliding_news, 10 ) ); ?>" type="text" id="number-of-sliding-news" maxlength="2" size="30" name="number_of_sliding_news" />
								<div class="help-icon" title="<?php esc_attr_e( 'Enter the number of sliding news that you want to display in a single cycle of news.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Sliding Speed -->
						<tr class="behavior-chart-configuration">
							<th scope="row"><label for="sliding-speed"><?php esc_html_e( 'Sliding Speed', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->sliding_speed, 10 ) ); ?>" type="text" id="sliding-speed" maxlength="2" size="30" name="sliding_speed" />
								<div class="help-icon" title="<?php esc_attr_e( 'Enter the speed of the sliding news. Values included between 1 and 10 are allowed.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Sliding Delay -->
						<tr class="behavior-chart-configuration">
							<th scope="row"><label for="sliding-delay"><?php esc_html_e( 'Sliding Delay', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->sliding_delay, 10 ) ); ?>" type="text" id="sliding-delay" maxlength="10" size="30" name="sliding_delay" />
								<div class="help-icon" title="<?php esc_attr_e( 'The delay of the sliding news in milliseconds.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<tr class="group-trigger" data-trigger-target="performance-chart-configuration">
							<th scope="row" class="group-title"><?php esc_attr_e( 'Performance', 'daln' ); ?></th>
							<td>
								<div class="expand-icon"></div>
							</td>
						</tr>

						<!-- Cached Cycled -->
						<tr class="performance-chart-configuration">
							<th scope="row"><label for="cached-cycles"><?php esc_html_e( 'Cached Cycles', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->cached_cycles, 10 ) ); ?>" type="text" id="cached-cycles" maxlength="10" size="30" name="cached_cycles" />
								<div class="help-icon" title="<?php esc_attr_e( 'This value determines the number of cycles performed by the news ticker without updating the news. Set an high value to improve the news ticker performance and to avoid an excessive load on the web server. Set a low value to have frequent updates of the news. Set 0 to update the news at every cycle.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Transient Expiration -->
						<tr class="performance-chart-configuration">
							<th scope="row"><label for="clock-background-image"><?php esc_html_e( 'Transient Expiration', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo intval( $ticker_obj->transient_expiration, 10 ); ?>" type="text" id="transient-expiration" maxlength="10" size="30" name="transient_expiration"/>
								<div class="help-icon" title="<?php esc_attr_e( 'Enter the transient expiration in seconds. Set an high value to improve the news ticker performance and to avoid an excessive load on the web server. Set a low value to have frequent updates of the news. Set 0 to not use a transient.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<tr class="group-trigger" data-trigger-target="style-chart-configuration">
							<th scope="row" class="group-title"><?php esc_html_e( 'Style', 'daln' ); ?></th>
							<td>
								<div class="expand-icon"></div>
							</td>
						</tr>

						<!-- Featured Title Maximum Length -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="featured-title-maximum-length"><?php esc_html_e( 'Featured News Title Maximum Length', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->featured_title_maximum_length, 10 ) ); ?>" type="text" id="featured-title-maximum-length" maxlength="4" size="30" name="featured_title_maximum_length" />
								<div class="help-icon" title="<?php esc_attr_e( 'The maximum length of the featured news title.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Featured Excerpt Maximum Length -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="featured-excerpt-maximum-length"><?php esc_html_e( 'Featured News Excerpt Maximum Length', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->featured_excerpt_maximum_length, 10 ) ); ?>" type="text" id="featured-excerpt-maximum-length" maxlength="4" size="30" name="featured_excerpt_maximum_length" />
								<div class="help-icon" title="<?php esc_attr_e( 'The maximum length of the featured news excerpt.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Sliding News Maximum Length -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="sliding-news-maximum-length"><?php esc_html_e( 'Sliding News Maximum Length', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->sliding_news_maximum_length, 10 ) ); ?>" type="text" id="sliding-news-maximum-length" maxlength="4" size="30" name="sliding_news_maximum_length" />
								<div class="help-icon" title="<?php esc_attr_e( 'The maximum length of the sliding news.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Featured Title Font Size -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="featured-title-font-size"><?php esc_html_e( 'Featured News Title Font Size', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->featured_title_font_size, 10 ) ); ?>" type="text" id="featured-title-font-size" maxlength="2" size="30" name="featured_title_font_size" />
								<div class="help-icon" title="<?php esc_attr_e( 'The font size of the featured news title.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Featured Excerpt Font Size -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="featured-excerpt-font-size"><?php esc_html_e( 'Featured News Excerpt Font Size', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->featured_excerpt_font_size, 10 ) ); ?>" type="text" id="featured-excerpt-font-size" maxlength="2" size="30" name="featured_excerpt_font_size" />
								<div class="help-icon" title="<?php esc_attr_e( 'The font size of the featured news excerpt.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Sliding News Font Size -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="sliding-news-font-size"><?php esc_html_e( 'Sliding News Font Size', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->sliding_news_font_size, 10 ) ); ?>" type="text" id="sliding-news-font-size" maxlength="2" size="30" name="sliding_news_font_size" />
								<div class="help-icon" title="<?php esc_attr_e( 'The font size of the sliding news.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Clock Font Size -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="clock-font-size"><?php esc_html_e( 'Clock Font Size', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->clock_font_size, 10 ) ); ?>" type="text" id="clock-font-size" maxlength="2" size="30" name="clock_font_size" />
								<div class="help-icon" title="<?php esc_attr_e( 'The font size of the text in the clock.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Sliding News Margin -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="sliding-news-margin"><?php esc_html_e( 'Sliding News Margin', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->sliding_news_margin, 10 ) ); ?>" type="text" id="sliding-news-margin" maxlength="3" size="30" name="sliding_news_margin" />
								<div class="help-icon" title="<?php esc_attr_e( 'The margin between the sliding news.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Sliding News Padding -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="sliding-news-padding"><?php esc_html_e( 'Sliding News Padding', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo abs( intval( $ticker_obj->sliding_news_padding, 10 ) ); ?>" type="text" id="sliding-news-padding" maxlength="3" size="30" name="sliding_news_padding" />
								<div class="help-icon" title="<?php esc_attr_e( 'This option determines the padding on the left and on the right of each sliding news and also the distance between the sliding news text and the sliding news left and right images.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Font Family -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="font-family"><?php esc_html_e( 'Font Family', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->font_family ) ); ?>" type="text" id="font-family" maxlength="255" size="30" name="font_family" />
								<div class="help-icon" title="<?php esc_attr_e( 'The font family used for all the text displayed in the news ticker.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Google Font -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="google-font"><?php esc_html_e( 'Google Font', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_url( stripslashes( $ticker_obj->google_font ) ); ?>" type="text" id="google-font" maxlength="255" size="30" name="google_font" />
								<div class="help-icon" title="<?php esc_attr_e( 'This option allows you to load a specific Google Font.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Featured News Title Color -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="featured-news-title-color"><?php esc_html_e( 'Featured News Title Color', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->featured_news_title_color ) ); ?>" class="wp-color-picker" type="text" id="featured-news-title-color" maxlength="7" size="30" name="featured_news_title_color" />
								<div class="help-icon" title="<?php esc_attr_e( 'The color of the featured news title.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Featured News Title Color Hover -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="featured-news-title-color-hover"><?php esc_html_e( 'Featured News Title Color Hover', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->featured_news_title_color_hover ) ); ?>" class="wp-color-picker" type="text" id="featured-news-title-color-hover" maxlength="7" size="30" name="featured_news_title_color_hover" />
								<div class="help-icon" title="<?php esc_attr_e( 'The color of the featured news title in hover status.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Featured News Excerpt Color -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="featured-news-excerpt-color"><?php esc_html_e( 'Featured News Excerpt Color', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->featured_news_excerpt_color ) ); ?>" class="wp-color-picker" type="text" id="featured-news-excerpt-color" maxlength="7" size="30" name="featured_news_excerpt_color" />
								<div class="help-icon" title="<?php esc_attr_e( 'The color of the featured news excerpt.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Sliding News Color -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="sliding-news-color"><?php esc_html_e( 'Sliding News Color', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->sliding_news_color ) ); ?>" class="wp-color-picker" type="text" id="sliding-news-color" maxlength="7" size="30" name="sliding_news_color" />
								<div class="help-icon" title="<?php esc_attr_e( 'The color of the sliding news.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Sliding News Color Hover -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="sliding-news-color-hover"><?php esc_html_e( 'Sliding News Color Hover', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->sliding_news_color_hover ) ); ?>" class="wp-color-picker" type="text" id="sliding-news-color-hover" maxlength="7" size="30" name="sliding_news_color_hover" />
								<div class="help-icon" title="<?php esc_attr_e( 'The color of the sliding news in hover status.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Clock Text Color -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="clock-text-color"><?php esc_html_e( 'Clock Text Color', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->clock_text_color ) ); ?>" class="wp-color-picker" type="text" id="clock-text-color" maxlength="7" size="30" name="clock_text_color" />
								<div class="help-icon" title="<?php esc_attr_e( 'The color of the text displayed in the clock.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Featured News Background Color -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="featured-news-background-color"><?php esc_html_e( 'Featured News Background Color', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->featured_news_background_color ) ); ?>" class="wp-color-picker" type="text" id="featured-news-background-color" maxlength="7" size="30" name="featured_news_background_color" />
								<div class="help-icon" title="<?php esc_attr_e( 'The background color of the featured news area.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Featured News Background Color Opacity -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="featured-news-background-color-opacity"><?php esc_html_e( 'Featured News Background Color Opacity', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo floatval( $ticker_obj->featured_news_background_color_opacity ); ?>" type="text" id="featured-news-background-color-opacity" maxlength="3" size="30" name="featured_news_background_color_opacity" />
								<div class="help-icon" title="<?php esc_attr_e( 'The background color opacity of the featured news area.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Sliding News Background Color -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="sliding-news-background-color"><?php esc_html_e( 'Sliding News Background Color', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo esc_attr( stripslashes( $ticker_obj->sliding_news_background_color ) ); ?>" class="wp-color-picker" type="text" id="sliding-news-background-color" maxlength="7" size="30" name="sliding_news_background_color" />
								<div class="help-icon" title="<?php esc_attr_e( 'The background color of the sliding news area.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Sliding News Background Color Opacity -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="sliding-news-background-color-opacity"><?php esc_html_e( 'Sliding News Background Color Opacity', 'daln' ); ?></label></th>
							<td>
								<input value="<?php echo floatval( stripslashes( $ticker_obj->sliding_news_background_color_opacity ) ); ?>" type="text" id="sliding-news-background-color-opacity" maxlength="3" size="30" name="sliding_news_background_color_opacity" />
								<div class="help-icon" title="<?php esc_attr_e( 'The background color opacity of the sliding news area.', 'daln' ); ?>"></div>
							</td>
						</tr>

						<!-- Open Button Image -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="open-button-image"><?php esc_html_e( 'Open Button Image', 'daln' ); ?></label></th>
							<td>

								<div class="image-uploader">
									<img class="selected-image" src="<?php echo esc_attr( stripslashes( $ticker_obj->open_button_image ) ); ?>" <?php echo mb_strlen( trim( $ticker_obj->open_button_image ) ) === 0 ? 'style="display: none;"' : ''; ?>>
									<input value="<?php echo esc_attr( stripslashes( $ticker_obj->open_button_image ) ); ?>" type="hidden" id="open-button-image" maxlength="2083" name="open_button_image">
									<a class="button_add_media" data-set-remove="<?php echo mb_strlen( trim( $ticker_obj->open_button_image ) ) === 0 ? 'set' : 'remove'; ?>" data-set="<?php esc_attr_e( 'Set image', 'daln' ); ?>" data-remove="<?php esc_attr_e( 'Remove Image', 'daln' ); ?>"><?php echo mb_strlen( trim( $ticker_obj->open_button_image ) ) === 0 ? esc_attr__( 'Set image', 'daln' ) : esc_attr__( 'Remove Image', 'daln' ); ?></a>
									<p class="description"><?php esc_html_e( "Select the image of the button used to open the news ticker. It's recommended to use an image with a width of 80 pixels and a height of 40 pixels.", 'daln' ); ?></p>
								</div>

							</td>
						</tr>

						<!-- Close Button Image -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="open-button-image"><?php esc_html_e( 'Close Button Image', 'daln' ); ?></label></th>
							<td>

								<div class="image-uploader">
									<img class="selected-image" src="<?php echo esc_attr( stripslashes( $ticker_obj->close_button_image ) ); ?>" <?php echo mb_strlen( trim( $ticker_obj->close_button_image ) ) === 0 ? 'style="display: none;"' : ''; ?>>
									<input value="<?php echo esc_attr( stripslashes( $ticker_obj->close_button_image ) ); ?>" type="hidden" id="close-button-image" maxlength="2083" name="close_button_image">
									<a class="button_add_media" data-set-remove="<?php echo mb_strlen( trim( $ticker_obj->close_button_image ) ) === 0 ? 'set' : 'remove'; ?>" data-set="<?php esc_attr_e( 'Set image', 'daln' ); ?>" data-remove="<?php esc_attr_e( 'Remove Image', 'daln' ); ?>"><?php echo mb_strlen( trim( $ticker_obj->close_button_image ) ) === 0 ? esc_attr__( 'Set image', 'daln' ) : esc_attr__( 'Remove Image', 'daln' ); ?></a>
									<p class="description"><?php esc_html_e( "Select the image of the button used to close the news ticker. It's recommended to use an image with a width of 80 pixels and a height of 40 pixels.", 'daln' ); ?></p>
								</div>

							</td>
						</tr>

						<!-- Clock Background Image -->
						<tr class="style-chart-configuration">
							<th scope="row"><label for="clock-background-image"><?php esc_html_e( 'Clock Background Image', 'daln' ); ?></label></th>
							<td>

								<div class="image-uploader">
									<img class="selected-image" src="<?php echo esc_attr( stripslashes( $ticker_obj->clock_background_image ) ); ?>" <?php echo mb_strlen( trim( $ticker_obj->clock_background_image ) ) === 0 ? 'style="display: none;"' : ''; ?>>
									<input value="<?php echo esc_attr( stripslashes( $ticker_obj->clock_background_image ) ); ?>" type="hidden" id="clock-background-image" maxlength="2083" name="clock_background_image">
									<a class="button_add_media" data-set-remove="<?php echo mb_strlen( trim( $ticker_obj->clock_background_image ) ) === 0 ? 'set' : 'remove'; ?>" data-set="<?php esc_attr_e( 'Set image', 'daln' ); ?>" data-remove="<?php esc_attr_e( 'Remove Image', 'daln' ); ?>"><?php echo mb_strlen( trim( $ticker_obj->clock_background_image ) ) === 0 ? esc_attr__( 'Set image', 'daln' ) : esc_attr__( 'Remove Image', 'daln' ); ?></a>
									<p class="description"><?php esc_html_e( "Select the background image of the clock. It's recommended to use an image with a width of 80 pixels and a height of 40 pixels.", 'daln' ); ?></p>
								</div>

							</td>
						</tr>

						<tr class="group-trigger" data-trigger-target="section-advanced">
							<th scope="row" class="group-title"><?php esc_html_e( 'Advanced', 'daln' ); ?></th>
							<td>
								<div class="expand-icon"></div>
							</td>
						</tr>

						<!-- Target URL Mode -->
						<tr class="section-advanced">
							<th scope="row"><?php esc_html_e( 'Target URL Mode', 'daln' ); ?></th>
							<td>
								<select id="url-mode" name="url_mode">
									<option value="0" <?php selected( $ticker_obj->url_mode, 0 ); ?>><?php esc_html_e( 'Include', 'daln' ); ?></option>
									<option value="1" <?php selected( $ticker_obj->url_mode, 1 ); ?>><?php esc_html_e( 'Exclude', 'daln' ); ?></option>
								</select>
								<div class="help-icon" title='<?php esc_attr_e( 'Select whether to include or exclude the URLs defined with the "Target URL" option.', 'daln' ); ?>'></div>
							</td>
						</tr>

					</table>

					<!-- submit button -->
					<div class="daext-form-action">
						<input class="button" type="submit" value="<?php esc_html_e( 'Update News Ticker', 'daln' ); ?>" >
					</div>

					<?php else : ?>

					<!-- Create New Ticker -->

					<div class="daext-form-container">

						<div class="daext-form-title"><?php esc_html_e( 'Create a News Ticker', 'daln' ); ?></div>

						<table class="daext-form">

							<!-- Name -->
							<tr valign="top">
								<th scope="row"><label for="name"><?php esc_html_e( 'Name', 'daln' ); ?></label></th>
								<td>
									<input type="text" id="name" maxlength="100" size="30" name="name" />
									<div class="help-icon" title="<?php esc_attr_e( 'The name of the news ticker.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Target -->
							<tr valign="top">
								<th scope="row"><label for="target"><?php esc_html_e( 'Target', 'daln' ); ?></label></th>
								<td>
									<select id="target" name="target" class="daext-display-none">
										<option value="1"><?php esc_html_e( 'Website', 'daln' ); ?></option>
										<option value="2"><?php esc_html_e( 'URL', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'This selection determines if the news ticker should be applied to the entire website or to a specific URL. Note that a news ticker associated with an URL has the priority over the news ticker associated with the entire website.', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- URL -->
							<tr valign="top">
								<th scope="row"><label for="url"><?php esc_html_e( ' Target URL', 'daln' ); ?></label></th>
								<td>
									<textarea type="text" id="url" maxlength="20830000" size="30" name="url"></textarea>
									<div class="help-icon" title="<?php esc_attr_e( 'Enter one or more URLs. (one URL per line) This option is used only if the target of the news ticker is "URL".', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Enable Ticker -->
							<tr>
								<th scope="row"><?php esc_attr_e( 'Enable Ticker', 'daln' ); ?></th>
								<td>
									<select id="enable-ticker" name="enable_ticker" class="daext-display-none">
										<option value="0"><?php esc_html_e( 'No', 'daln' ); ?></option>
										<option value="1" selected="selected"><?php esc_html_e( 'Yes', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'Use this option to enable or disable the news ticker on the front-end.', 'daln' ); ?>'></div>
								</td>
							</tr>

							<tr class="group-trigger" data-trigger-target="source-chart-configuration">
								<th scope="row" class="group-title"><?php esc_html_e( 'Source', 'daln' ); ?></th>
								<td>
									<div class="expand-icon"></div>
								</td>
							</tr>

							<!-- Source -->
							<tr class="source-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Source', 'daln' ); ?></th>
								<td>
									<select id="source" name="source">
										<option value="1"><?php esc_html_e( 'Manually Added', 'daln' ); ?></option>
										<option value="2"><?php esc_html_e( 'Posts', 'daln' ); ?></option>
										<option value="3"><?php esc_html_e( 'RSS', 'daln' ); ?></option>
										<option value="4"><?php esc_html_e( 'Twitter', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'This option determines where the news displayed in the news ticker are retrieved. Please note that with the "Twitter" source the news are displayed only in the sliding news area.', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Category -->
							<tr class="source-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Category', 'daln' ); ?></th>
								<td>
									<select id="category" name="category">
										<option value="0"><?php esc_html_e( 'All', 'daln' ); ?></option>

										<?php

										$args       = array(
											'type' => 'post',
										);
										$categories = get_categories( $args );
										foreach ( $categories as $category ) {
											echo '<option value="' . esc_attr( $category->term_id ) . '">' . esc_html( $category->name ) . '</option>';
										}

										?>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'Select if the news should be retrieved from all the posts or only from the posts of a specific category. This option is used only if the source of the news ticker is "Posts".', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- URL RSS -->
							<tr class="source-chart-configuration">
								<th scope="row"><label for="url-rss"><?php esc_html_e( 'Source RSS', 'daln' ); ?></label></th>
								<td>
									<input type="text" id="url-rss" maxlength="2083" size="30" name="url_rss" />
									<div class="help-icon" title="<?php esc_attr_e( 'Enter the RSS Feed used to generate the news. This option is used only if the source of the news ticker is "RSS".', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Twitter Username -->
							<tr class="source-chart-configuration">
								<th scope="row"><label for="twitter-username"><?php esc_html_e( 'Twitter Username', 'daln' ); ?></label></th>
								<td>
									<input type="text" id="twitter-username" maxlength="255" size="30" name="twitter_username"/>
									<div class="help-icon" title="<?php esc_attr_e( 'Enter the Twitter username for which you want to retrieve the tweets. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Twitter Oauth Access Token -->
							<tr class="source-chart-configuration">
								<th scope="row"><label for="twitter-oauth-access-token"><?php esc_html_e( 'Twitter Oauth Access Token', 'daln' ); ?></label></th>
								<td>
									<input type="text" id="twitter-oauth-access-token" maxlength="255" size="30" name="twitter_oauth_access_token"/>
									<div class="help-icon" title="<?php esc_attr_e( 'Enter your Twitter Oauth Access Token. This token is available in the "Keys and Access Token" section of the Twitter App. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Twitter Oauth Access Token Secret -->
							<tr class="source-chart-configuration">
								<th scope="row"><label for="twitter-oauth-access-token-secret"><?php esc_html_e( 'Twitter Oauth Access Token Secret', 'daln' ); ?></label></th>
								<td>
									<input type="text" id="twitter-oauth-access-token-secret" maxlength="255" size="30" name="twitter_oauth_access_token_secret"/>
									<div class="help-icon" title="<?php esc_attr_e( 'Enter your Twitter Oauth Access Token Secret. This token is available in the "Keys and Access Token" section of the Twitter App. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Twitter Consumer Key -->
							<tr class="source-chart-configuration">
								<th scope="row"><label for="twitter-consumer-key"><?php esc_html_e( 'Twitter Consumer Key', 'daln' ); ?></label></th>
								<td>
									<input type="text" id="twitter-consumer-key" maxlength="255" size="30" name="twitter_consumer_key"/>
									<div class="help-icon" title="<?php esc_attr_e( 'Enter your Twitter Consumer Key. This key is available in the "Keys and Access Token" section of the Twitter App. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Twitter Consumer Secret -->
							<tr class="source-chart-configuration">
								<th scope="row"><label for="twitter-consumer-secret"><?php esc_html_e( 'Twitter Consumer Secret', 'daln' ); ?></label></th>
								<td>
									<input type="text" id="twitter-consumer-secret" maxlength="255" size="30" name="twitter_consumer_secret"/>
									<div class="help-icon" title="<?php esc_attr_e( 'Enter your Twitter Consumer Secret. This key is available in the "Keys and Access Token" section of the Twitter App. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Twitter Strip Links -->
							<tr class="source-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Twitter Strip Links', 'daln' ); ?></th>
								<td>
									<select id="twitter-strip-links" name="twitter_strip_links">
										<option value="0"><?php esc_html_e( 'No', 'daln' ); ?></option>
										<option value="1"><?php esc_html_e( 'Yes', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'This option determines if the links should be removed from the imported tweets. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Twitter Strip Hashtags -->
							<tr class="source-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Twitter Strip Hashtags', 'daln' ); ?></th>
								<td>
									<select id="twitter-strip-hashtags" name="twitter_strip_hashtags">
										<option value="0"><?php esc_html_e( 'No', 'daln' ); ?></option>
										<option value="1"><?php esc_html_e( 'Yes', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'This option determines if the hashtags should be removed from the imported tweets. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Twitter Strip Usernames -->
							<tr class="source-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Twitter Strip Usernames', 'daln' ); ?></th>
								<td>
									<select id="twitter-strip-usernames" name="twitter_strip_usernames">
										<option value="0"><?php esc_html_e( 'No', 'daln' ); ?></option>
										<option value="1"><?php esc_html_e( 'Yes', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'This option determines if the usernames should be removed from the imported tweets. This option is used only if the source of the news ticker is "Twitter".', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Clock Source -->
							<tr class="source-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Clock Source', 'daln' ); ?></th>
								<td>
									<select id="clock-source" name="clock_source">
										<option value="1"><?php esc_html_e( 'Server Time', 'daln' ); ?></option>
										<option value="2" selected="selected"><?php esc_html_e( 'User Time', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'Select if the time should be based on the server time or on the user time. Please note that by selecting "Server Time" the clock will be updated only when the news are retrieved from the server, therefore this option should not be used if you are caching cycles of news or if you are using transients.', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Clock Offset -->
							<tr class="source-chart-configuration">
								<th scope="row"><label for="clock-offset"><?php esc_html_e( 'Clock Offset', 'daln' ); ?></label></th>
								<td>
									<input value="0" type="text" id="clock-offset" maxlength="6" size="30" name="clock_offset" />
									<div class="help-icon" title="<?php esc_attr_e( 'The clock offset in seconds. Positive or negative values are allowed.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Clock Format -->
							<tr class="source-chart-configuration">
								<th scope="row"><label for="clock-format"><?php esc_html_e( 'Clock Format', 'daln' ); ?></label></th>
								<td>
									<input value="HH:mm" type="text" id="clock-format" maxlength="40" size="30" name="clock_format" />
									<div class="help-icon" title="<?php esc_attr_e( 'Use this field to specify the clock format. The tokens supported by Moment.js should be used.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<tr class="group-trigger" data-trigger-target="behavior-chart-configuration">
								<th scope="row" class="group-title"><?php esc_html_e( 'Behavior', 'daln' ); ?></th>
								<td>
									<div class="expand-icon"></div>
								</td>
							</tr>

							<!-- Enable RTL Layout -->
							<tr class="behavior-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Enable RTL Layout', 'daln' ); ?></th>
								<td>
									<select id="enable-rtl-layout" name="enable_rtl_layout">
										<option value="0"><?php esc_html_e( 'No', 'daln' ); ?></option>
										<option value="1"><?php esc_html_e( 'Yes', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'Select whether to enable or not the RTL layout.', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Enable with Mobile Devices -->
							<tr class="behavior-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Enable with Mobile Devices', 'daln' ); ?></th>
								<td>
									<select id="enable-with-mobile-devices" name="enable_with_mobile_devices">
										<option value="0"><?php esc_html_e( 'No', 'daln' ); ?></option>
										<option value="1"><?php esc_html_e( 'Yes', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'Select whether to display or not the news ticker with mobile devices. The user-agent string combined with specific HTTP headers are used to determine the device.', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Hide Featured News -->
							<tr class="behavior-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Hide Featured News', 'daln' ); ?></th>
								<td>
									<select id="hide-featured-news" name="hide_featured_news">
										<option value="1"><?php esc_html_e( 'No', 'daln' ); ?></option>
										<option value="2"><?php esc_html_e( 'Yes', 'daln' ); ?></option>
										<option value="3"><?php esc_html_e( 'Only with Mobile Devices', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'Select if the featured news area of the news ticker should be displayed.', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Open News as Default -->
							<tr class="behavior-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Open News as Default', 'daln' ); ?></th>
								<td>
									<select id="open-news-as-default" name="open_news_as_default">
										<option value="0"><?php esc_html_e( 'No', 'daln' ); ?></option>
										<option value="1" selected="selected"><?php esc_html_e( 'Yes', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'Select if the news ticker should be presented in the open status (with the featured news area visible) to the users. If the user opens or closes the news ticker the new status will be saved in a cookie and used to determine the default status of the news ticker for that specific user.', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Enable Links -->
							<tr class="behavior-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Enable Links', 'daln' ); ?></th>
								<td>
									<select id="enable-links" name="enable_links">
										<option value="0"><?php esc_html_e( 'No', 'daln' ); ?></option>
										<option value="1" selected="selected"><?php esc_html_e( 'Yes', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'Whether to apply or not the links associated with the news on the featured news title and on the sliding news.', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Open Links New Tab -->
							<tr class="behavior-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Open Links in New Tab', 'daln' ); ?></th>
								<td>
									<select id="open-links-new-tab" name="open_links_new_tab">
										<option value="0"><?php esc_html_e( 'No', 'daln' ); ?></option>
										<option value="1"><?php esc_html_e( 'Yes', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'Select if the links availble in the news ticker should be opened in a new tab.', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Hide Clock -->
							<tr class="behavior-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Hide Clock', 'daln' ); ?></th>
								<td>
									<select id="hide-clock" name="hide_clock">
										<option value="0"><?php esc_html_e( 'No', 'daln' ); ?></option>
										<option value="1"><?php esc_html_e( 'Yes', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'Select whether to display or not the clock.', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Clock Autoupdate -->
							<tr class="behavior-chart-configuration">
								<th scope="row"><?php esc_html_e( 'Clock Autoupdate', 'daln' ); ?></th>
								<td>
									<select id="clock-autoupdate" name="clock_autoupdate">
										<option value="0"><?php esc_html_e( 'No', 'daln' ); ?></option>
										<option value="1" selected="selected"><?php esc_html_e( 'Yes', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'Select whether to autoupdate or not the clock independently from the cycles of news received. This option is applied only if the source of the clock is "User Time".', 'daln' ); ?>'></div>
								</td>
							</tr>

							<!-- Clock Autoupdate Time -->
							<tr class="behavior-chart-configuration">
								<th scope="row"><label for="clock-autoupdate-time"><?php esc_html_e( 'Clock Autoupdate Time', 'daln' ); ?></label></th>
								<td>
									<input value="10" type="text" id="clock-autoupdate-time" maxlength="10" size="30" name="clock_autoupdate_time" />
									<div class="help-icon" title="<?php esc_attr_e( 'This option determines how frequent should be the clock autoupdate in seconds.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Number of Sliding News -->
							<tr class="behavior-chart-configuration">
								<th scope="row"><label for="number-of-sliding-news"><?php esc_html_e( 'Number of Sliding News', 'daln' ); ?></label></th>
								<td>
									<input value="10" type="text" id="number-of-sliding-news" maxlength="2" size="30" name="number_of_sliding_news" />
									<div class="help-icon" title="<?php esc_attr_e( 'Enter the number of sliding news that you want to display in a single cycle of news.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Sliding Speed -->
							<tr class="behavior-chart-configuration">
								<th scope="row"><label for="sliding-speed"><?php esc_html_e( 'Sliding Speed', 'daln' ); ?></label></th>
								<td>
									<input value="5" type="text" id="sliding-speed" maxlength="2" size="30" name="sliding_speed" />
									<div class="help-icon" title="<?php esc_attr_e( 'Enter the speed of the sliding news. Values included between 1 and 10 are allowed.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Sliding Delay -->
							<tr class="behavior-chart-configuration">
								<th scope="row"><label for="sliding-delay"><?php esc_html_e( 'Sliding Delay', 'daln' ); ?></label></th>
								<td>
									<input value="0" type="text" id="sliding-delay" maxlength="10" size="30" name="sliding_delay" />
									<div class="help-icon" title="<?php esc_attr_e( 'The delay of the sliding news in milliseconds.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<tr class="group-trigger" data-trigger-target="performance-chart-configuration">
								<th scope="row" class="group-title"><?php esc_attr_e( 'Performance', 'daln' ); ?></th>
								<td>
									<div class="expand-icon"></div>
								</td>
							</tr>

							<!-- Cached Cycles -->
							<tr class="performance-chart-configuration">
								<th scope="row"><label for="cached-cycles"><?php esc_html_e( 'Cached Cycles', 'daln' ); ?></label></th>
								<td>
									<input value="5" type="text" id="cached-cycles" maxlength="10" size="30" name="cached_cycles" />
									<div class="help-icon" title="<?php esc_attr_e( 'This value determines the number of cycles performed by the news ticker without updating the news. Set an high value to improve the news ticker performance and to avoid an excessive load on the web server. Set a low value to have frequent updates of the news. Set 0 to update the news at every cycle.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Transient Expiration -->
							<tr class="performance-chart-configuration">
								<th scope="row"><label for="transient-expiration"><?php esc_html_e( 'Transient Expiration', 'daln' ); ?></label></th>
								<td>
									<input value="60" type="text" id="transient-expiration" maxlength="10" size="30" name="transient_expiration"/>
									<div class="help-icon" title="<?php esc_attr_e( 'Enter the transient expiration in seconds. Set an high value to improve the news ticker performance and to avoid an excessive load on the web server. Set a low value to have frequent updates of the news. Set 0 to not use a transient.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<tr class="group-trigger" data-trigger-target="style-chart-configuration">
								<th scope="row" class="group-title"><?php esc_html_e( 'Style', 'daln' ); ?></th>
								<td>
									<div class="expand-icon"></div>
								</td>
							</tr>

							<!-- Featured Title Maximum Length -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="featured-title-maximum-length"><?php esc_html_e( 'Featured News Title Maximum Length', 'daln' ); ?></label></th>
								<td>
									<input value="280" type="text" id="featured-title-maximum-length" maxlength="4" size="30" name="featured_title_maximum_length" />
									<div class="help-icon" title="<?php esc_attr_e( 'The maximum length of the featured news title.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Featured Excerpt Maximum Length -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="featured-excerpt-maximum-length"><?php esc_html_e( 'Featured News Excerpt Maximum Length', 'daln' ); ?></label></th>
								<td>
									<input value="280" type="text" id="featured-excerpt-maximum-length" maxlength="4" size="30" name="featured_excerpt_maximum_length" />
									<div class="help-icon" title="<?php esc_attr_e( 'The maximum length of the featured news excerpt.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Sliding News Maximum Length -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="sliding-news-maximum-length"><?php esc_html_e( 'Sliding News Maximum Length', 'daln' ); ?></label></th>
								<td>
									<input value="280" type="text" id="sliding-news-maximum-length" maxlength="4" size="30" name="sliding_news_maximum_length" />
									<div class="help-icon" title="<?php esc_attr_e( 'The maximum length of the sliding news.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Featured Title Font Size -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="featured-title-font-size"><?php esc_html_e( 'Featured News Title Font Size', 'daln' ); ?></label></th>
								<td>
									<input value="38" type="text" id="featured-title-font-size" maxlength="2" size="30" name="featured_title_font_size" />
									<div class="help-icon" title="<?php esc_attr_e( 'The font size of the featured news title.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Featured Excerpt Font Size -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="featured-excerpt-font-size"><?php esc_html_e( 'Featured News Excerpt Font Size', 'daln' ); ?></label></th>
								<td>
									<input value="28" type="text" id="featured-excerpt-font-size" maxlength="2" size="30" name="featured_excerpt_font_size" />
									<div class="help-icon" title="<?php esc_attr_e( 'The font size of the featured news excerpt.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Sliding News Font Size -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="sliding-news-font-size"><?php esc_html_e( 'Sliding News Font Size', 'daln' ); ?></label></th>
								<td>
									<input value="28" type="text" id="sliding-news-font-size" maxlength="2" size="30" name="sliding_news_font_size" />
									<div class="help-icon" title="<?php esc_attr_e( 'The font size of the sliding news.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Clock Font Size -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="clock-font-size"><?php esc_html_e( 'Clock Font Size', 'daln' ); ?></label></th>
								<td>
									<input value="28" type="text" id="clock-font-size" maxlength="2" size="30" name="clock_font_size" />
									<div class="help-icon" title="<?php esc_attr_e( 'The font size of the text in the clock.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Sliding News Margin -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="sliding-news-margin"><?php esc_html_e( 'Sliding News Margin', 'daln' ); ?></label></th>
								<td>
									<input value="84" type="text" id="sliding-news-margin" maxlength="3" size="30" name="sliding_news_margin" />
									<div class="help-icon" title="<?php esc_attr_e( 'The margin between the sliding news.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Sliding News Padding -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="sliding-news-padding"><?php esc_html_e( 'Sliding News Padding', 'daln' ); ?></label></th>
								<td>
									<input value="28" type="text" id="sliding-news-padding" maxlength="3" size="30" name="sliding_news_padding" />
									<div class="help-icon" title="<?php esc_attr_e( 'This option determines the padding on the left and on the right of each sliding news and also the distance between the sliding news text and the sliding news left and right images.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Font Family -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="font-family"><?php esc_html_e( 'Font Family', 'daln' ); ?></label></th>
								<td>
									<input value="'Open Sans', sans-serif" type="text" id="font-family" maxlength="255" size="30" name="font_family" />
									<div class="help-icon" title="<?php esc_attr_e( 'The font family used for all the text displayed in the news ticker.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Google Font -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="google-font"><?php esc_html_e( 'Google Font', 'daln' ); ?></label></th>
								<td>
									<input value="https://fonts.googleapis.com/css?family=Open+Sans:400,600,700" type="text" id="google-font" maxlength="255" size="30" name="google_font" />
									<div class="help-icon" title="<?php esc_attr_e( 'This option allows you to load a specific Google Font.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Featured News Title Color -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="featured-news-title-color"><?php esc_html_e( 'Featured News Title Color', 'daln' ); ?></label></th>
								<td>
									<input value="#eee" class="wp-color-picker" type="text" id="featured-news-title-color" maxlength="7" size="30" name="featured_news_title_color" />
									<div class="help-icon" title="<?php esc_attr_e( 'The color of the featured news title.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Featured News Title Color Hover -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="featured-news-title-color-hover"><?php esc_html_e( 'Featured News Title Color Hover', 'daln' ); ?></label></th>
								<td>
									<input value="#111" class="wp-color-picker" type="text" id="featured-news-title-color-hover" maxlength="7" size="30" name="featured_news_title_color_hover" />
									<div class="help-icon" title="<?php esc_attr_e( 'The color of the featured news title in hover status.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Featured News Excerpt Color -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="featured-news-excerpt-color"><?php esc_html_e( 'Featured News Excerpt Color', 'daln' ); ?></label></th>
								<td>
									<input value="#eee" class="wp-color-picker" type="text" id="featured-news-excerpt-color" maxlength="7" size="30" name="featured_news_excerpt_color" />
									<div class="help-icon" title="<?php esc_attr_e( 'The color of the featured news excerpt.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Sliding News Color -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="sliding-news-color"><?php esc_html_e( 'Sliding News Color', 'daln' ); ?></label></th>
								<td>
									<input value="#eee" class="wp-color-picker" type="text" id="sliding-news-color" maxlength="7" size="30" name="sliding_news_color" />
									<div class="help-icon" title="<?php esc_attr_e( 'The color of the sliding news.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Sliding News Color Hover -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="sliding-news-color-hover"><?php esc_html_e( 'Sliding News Color Hover', 'daln' ); ?></label></th>
								<td>
									<input value="#aaa" class="wp-color-picker" type="text" id="sliding-news-color-hover" maxlength="7" size="30" name="sliding_news_color_hover" />
									<div class="help-icon" title="<?php esc_attr_e( 'The color of the sliding news in hover status.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Clock Text Color -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="clock-text-color"><?php esc_html_e( 'Clock Text Color', 'daln' ); ?></label></th>
								<td>
									<input value="#111" class="wp-color-picker" type="text" id="clock-text-color" maxlength="7" size="30" name="clock_text_color" />
									<div class="help-icon" title="<?php esc_attr_e( 'The color of the text displayed in the clock.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Featured News Background Color -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="featured-news-background-color"><?php esc_html_e( 'Featured News Background Color', 'daln' ); ?></label></th>
								<td>
									<input value="#C90016" class="wp-color-picker" type="text" id="featured-news-background-color" maxlength="7" size="30" name="featured_news_background_color" />
									<div class="help-icon" title="<?php esc_attr_e( 'The background color of the featured news area.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Featured News Background Color Opacity -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="featured-news-background-color-opacity"><?php esc_html_e( 'Featured News Background Color Opacity', 'daln' ); ?></label></th>
								<td>
									<input value="1" type="text" id="featured-news-background-color-opacity" maxlength="3" size="30" name="featured_news_background_color_opacity" />
									<div class="help-icon" title="<?php esc_attr_e( 'The background color opacity of the featured news area.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Sliding News Background Color -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="sliding-news-background-color"><?php esc_html_e( 'Sliding News Background Color', 'daln' ); ?></label></th>
								<td>
									<input value="#000000" class="wp-color-picker" type="text" id="sliding-news-background-color" maxlength="7" size="30" name="sliding_news_background_color" />
									<div class="help-icon" title="<?php esc_attr_e( 'The background color of the sliding news area.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Sliding News Background Color Opacity -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="sliding-news-background-color-opacity"><?php esc_html_e( 'Sliding News Background Color Opacity', 'daln' ); ?></label></th>
								<td>
									<input value="1" type="text" id="sliding-news-background-color-opacity" maxlength="3" size="30" name="sliding_news_background_color_opacity" />
									<div class="help-icon" title="<?php esc_attr_e( 'The background color opacity of the sliding news area.', 'daln' ); ?>"></div>
								</td>
							</tr>

							<!-- Open Button Image -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="open-button-image"><?php esc_html_e( 'Open Button Image', 'daln' ); ?></label></th>
								<td>

									<div class="image-uploader">
										<img class="selected-image" src="<?php echo esc_attr( $this->shared->get( 'url' ) . 'public/assets/img/open-button.png' ); ?>" >
										<input value="<?php echo esc_attr( $this->shared->get( 'url' ) . 'public/assets/img/open-button.png' ); ?>" type="hidden" id="open-button-image" maxlength="2083" name="open_button_image">
										<a class="button_add_media" data-set-remove="remove" data-set="<?php esc_attr_e( 'Set image', 'daln' ); ?>" data-remove="<?php esc_attr_e( 'Remove Image', 'daln' ); ?>"><?php esc_html_e( 'Remove image', 'daln' ); ?></a>
										<p class="description"><?php esc_html_e( "Select the image of the button used to open the news ticker. It's recommended to use an image with a width of 80 pixels and a height of 40 pixels.", 'daln' ); ?></p>
									</div>

								</td>
							</tr>

							<!-- Close Button Image -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="close-button-image"><?php esc_html_e( 'Close Button Image', 'daln' ); ?></label></th>
								<td>

									<div class="image-uploader">
										<img class="selected-image" src="<?php echo esc_attr( $this->shared->get( 'url' ) . 'public/assets/img/close-button.png' ); ?>" >
										<input value="<?php echo esc_attr( $this->shared->get( 'url' ) . 'public/assets/img/close-button.png' ); ?>" type="hidden" id="close-button-image" maxlength="2083" name="close_button_image">
										<a class="button_add_media" data-set-remove="remove" data-set="<?php esc_attr_e( 'Set image', 'daln' ); ?>" data-remove="<?php esc_attr_e( 'Remove Image', 'daln' ); ?>"><?php esc_html_e( 'Remove image', 'daln' ); ?></a>
										<p class="description"><?php esc_html_e( "Select the image of the button used to close the news ticker. It's recommended to use an image with a width of 80 pixels and a height of 40 pixels.", 'daln' ); ?></p>
									</div>

								</td>
							</tr>

							<!-- Clock Background Image -->
							<tr class="style-chart-configuration">
								<th scope="row"><label for="clock-background-image"><?php esc_html_e( 'Clock Background Image', 'daln' ); ?></label></th>
								<td>

									<div class="image-uploader">
										<img class="selected-image" src="<?php echo esc_attr( $this->shared->get( 'url' ) . 'public/assets/img/clock.png' ); ?>" >
										<input value="<?php echo esc_attr( $this->shared->get( 'url' ) . 'public/assets/img/clock.png' ); ?>" type="hidden" id="clock-background-image" maxlength="2083" name="clock_background_image">
										<a class="button_add_media" data-set-remove="remove" data-set="<?php esc_attr_e( 'Set image', 'daln' ); ?>" data-remove="<?php esc_attr_e( 'Remove Image', 'daln' ); ?>"><?php esc_html_e( 'Remove image', 'daln' ); ?></a>
										<p class="description"><?php esc_html_e( "Select the background image of the clock. It's recommended to use an image with a width of 80 pixels and a height of 40 pixels.", 'daln' ); ?></p>
									</div>

								</td>
							</tr>

							<tr class="group-trigger" data-trigger-target="section-advanced">
								<th scope="row" class="group-title"><?php esc_html_e( 'Advanced', 'daln' ); ?></th>
								<td>
									<div class="expand-icon"></div>
								</td>
							</tr>

							<!-- Target URL Mode -->
							<tr class="section-advanced">
								<th scope="row"><?php esc_html_e( 'Target URL Mode', 'daln' ); ?></th>
								<td>
									<select id="url-mode" name="url_mode">
										<option value="0"><?php esc_html_e( 'Include', 'daln' ); ?></option>
										<option value="1"><?php esc_html_e( 'Exclude', 'daln' ); ?></option>
									</select>
									<div class="help-icon" title='<?php esc_attr_e( 'Select whether to include or exclude the URLs defined with the "Target URL" option.', 'daln' ); ?>'></div>
								</td>
							</tr>

						</table>

						<!-- submit button -->
						<div class="daext-form-action">
							<input class="button" type="submit" value="<?php esc_attr_e( 'Add News Ticker', 'daln' ); ?>" >
						</div>

						<?php endif; ?>

					</div>

			</form>

		<?php endif; ?>

	</div>

</div>